package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Toolbox: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧰",
        description = "toolbox",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("toolbox", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: tool: toolbox.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Toolbox: Emoji get() = _Toolbox
