package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithOpenEyesAndHandOverMouth: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫢",
        description = "face with open eyes and hand over mouth",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("face-with-open-eyes-and-hand-over-mouth", "hand-over-mouth"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hand: face with open eyes and hand over mouth.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithOpenEyesAndHandOverMouth: Emoji get() = _FaceWithOpenEyesAndHandOverMouth

/**
 * Alias to emoji [FaceWithOpenEyesAndHandOverMouth] (Smileys & Emotion: face-hand: face with open eyes and hand over mouth).
*/
public val Emoji.Companion.HandOverMouth: Emoji get() = _FaceWithOpenEyesAndHandOverMouth
