package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceVomiting: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤮",
        description = "face vomiting",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("face-vomiting", "vomit"),
        emoticons = listOf(":-O##"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: face vomiting.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceVomiting: Emoji get() = _FaceVomiting

/**
 * Alias to emoji [FaceVomiting] (Smileys & Emotion: face-unwell: face vomiting).
*/
public val Emoji.Companion.Vomit: Emoji get() = _FaceVomiting
