package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseProhibitedButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈲",
        description = "Japanese “prohibited” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-prohibited-button", "prohibited-button"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “prohibited” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseProhibitedButton: Emoji get() = _JapaneseProhibitedButton

/**
 * Alias to emoji [JapaneseProhibitedButton] (Symbols: alphanum: Japanese “prohibited” button).
*/
public val Emoji.Companion.ProhibitedButton: Emoji get() = _JapaneseProhibitedButton
