package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseServiceChargeButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈂️",
        description = "Japanese “service charge” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-service-charge-button", "service-charge"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “service charge” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseServiceChargeButton: Emoji get() = _JapaneseServiceChargeButton

/**
 * Alias to emoji [JapaneseServiceChargeButton] (Symbols: alphanum: Japanese “service charge” button).
*/
public val Emoji.Companion.ServiceCharge: Emoji get() = _JapaneseServiceChargeButton
