package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAlphanum() {
    add(intArrayOf(0x1f520), _InputLatinUppercase)
    add(intArrayOf(0x1f521), _InputLatinLowercase)
    add(intArrayOf(0x1f522), _InputNumbers)
    add(intArrayOf(0x1f523), _InputSymbols)
    add(intArrayOf(0x1f524), _InputLatinLetters)
    add(intArrayOf(0x1f170, 0xfe0f), _AButtonBloodType)
    add(intArrayOf(0x1f170), _AButtonBloodType)
    add(intArrayOf(0x1f18e), _AbButtonBloodType)
    add(intArrayOf(0x1f171, 0xfe0f), _BButtonBloodType)
    add(intArrayOf(0x1f171), _BButtonBloodType)
    add(intArrayOf(0x1f191), _ClButton)
    add(intArrayOf(0x1f192), _CoolButton)
    add(intArrayOf(0x1f193), _FreeButton)
    add(intArrayOf(0x2139, 0xfe0f), _Information)
    add(intArrayOf(0x2139), _Information)
    add(intArrayOf(0x1f194), _IdButton)
    add(intArrayOf(0x24c2, 0xfe0f), _CircledM)
    add(intArrayOf(0x24c2), _CircledM)
    add(intArrayOf(0x1f195), _NewButton)
    add(intArrayOf(0x1f196), _NgButton)
    add(intArrayOf(0x1f17e, 0xfe0f), _OButtonBloodType)
    add(intArrayOf(0x1f17e), _OButtonBloodType)
    add(intArrayOf(0x1f197), _OkButton)
    add(intArrayOf(0x1f17f, 0xfe0f), _PButton)
    add(intArrayOf(0x1f17f), _PButton)
    add(intArrayOf(0x1f198), _SosButton)
    add(intArrayOf(0x1f199), _UpButton)
    add(intArrayOf(0x1f19a), _VsButton)
    add(intArrayOf(0x1f201), _JapaneseHereButton)
    add(intArrayOf(0x1f202, 0xfe0f), _JapaneseServiceChargeButton)
    add(intArrayOf(0x1f202), _JapaneseServiceChargeButton)
    add(intArrayOf(0x1f237, 0xfe0f), _JapaneseMonthlyAmountButton)
    add(intArrayOf(0x1f237), _JapaneseMonthlyAmountButton)
    add(intArrayOf(0x1f236), _JapaneseNotFreeOfChargeButton)
    add(intArrayOf(0x1f22f), _JapaneseReservedButton)
    add(intArrayOf(0x1f250), _JapaneseBargainButton)
    add(intArrayOf(0x1f239), _JapaneseDiscountButton)
    add(intArrayOf(0x1f21a), _JapaneseFreeOfChargeButton)
    add(intArrayOf(0x1f232), _JapaneseProhibitedButton)
    add(intArrayOf(0x1f251), _JapaneseAcceptableButton)
    add(intArrayOf(0x1f238), _JapaneseApplicationButton)
    add(intArrayOf(0x1f234), _JapanesePassingGradeButton)
    add(intArrayOf(0x1f233), _JapaneseVacancyButton)
    add(intArrayOf(0x3297, 0xfe0f), _JapaneseCongratulationsButton)
    add(intArrayOf(0x3297), _JapaneseCongratulationsButton)
    add(intArrayOf(0x3299, 0xfe0f), _JapaneseSecretButton)
    add(intArrayOf(0x3299), _JapaneseSecretButton)
    add(intArrayOf(0x1f23a), _JapaneseOpenForBusinessButton)
    add(intArrayOf(0x1f235), _JapaneseNoVacancyButton)
}

internal suspend fun SequenceScope<Emoji>.yieldAllAlphanum() {
    yield(_InputLatinUppercase)
    yield(_InputLatinLowercase)
    yield(_InputNumbers)
    yield(_InputSymbols)
    yield(_InputLatinLetters)
    yield(_AButtonBloodType)
    yield(_AbButtonBloodType)
    yield(_BButtonBloodType)
    yield(_ClButton)
    yield(_CoolButton)
    yield(_FreeButton)
    yield(_Information)
    yield(_IdButton)
    yield(_CircledM)
    yield(_NewButton)
    yield(_NgButton)
    yield(_OButtonBloodType)
    yield(_OkButton)
    yield(_PButton)
    yield(_SosButton)
    yield(_UpButton)
    yield(_VsButton)
    yield(_JapaneseHereButton)
    yield(_JapaneseServiceChargeButton)
    yield(_JapaneseMonthlyAmountButton)
    yield(_JapaneseNotFreeOfChargeButton)
    yield(_JapaneseReservedButton)
    yield(_JapaneseBargainButton)
    yield(_JapaneseDiscountButton)
    yield(_JapaneseFreeOfChargeButton)
    yield(_JapaneseProhibitedButton)
    yield(_JapaneseAcceptableButton)
    yield(_JapaneseApplicationButton)
    yield(_JapanesePassingGradeButton)
    yield(_JapaneseVacancyButton)
    yield(_JapaneseCongratulationsButton)
    yield(_JapaneseSecretButton)
    yield(_JapaneseOpenForBusinessButton)
    yield(_JapaneseNoVacancyButton)
}

internal val countAlphanum = 39

/**
 * All Emoji of the Symbols: alphanum subgroup.
*/
public fun Emoji.Companion.sequenceAlphanum(): Sequence<Emoji> =
    sequence { yieldAllAlphanum() }

/**
 * All Emoji of the Symbols: alphanum subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listAlphanum(): List<Emoji> =
    ArrayList<Emoji>(countAlphanum).also { list -> sequenceAlphanum().forEach { list.add(it) } }

@Deprecated("Renamed listAlphanum.", replaceWith = ReplaceWith("listAlphanum()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allAlphanum(): List<Emoji> =
    listAlphanum()
