package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DimButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔅",
        description = "dim button",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("dim-button", "dim", "dimness"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: dim button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DimButton: Emoji get() = _DimButton

/**
 * Alias to emoji [DimButton] (Symbols: av-symbol: dim button).
*/
public val Emoji.Companion.Dim: Emoji get() = _DimButton

/**
 * Alias to emoji [DimButton] (Symbols: av-symbol: dim button).
*/
public val Emoji.Companion.Dimness: Emoji get() = _DimButton
