package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RedTrianglePointedUp: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔺",
        description = "red triangle pointed up",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("red-triangle-pointed-up", "triangle-pointed-up"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: red triangle pointed up.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RedTrianglePointedUp: Emoji get() = _RedTrianglePointedUp

/**
 * Alias to emoji [RedTrianglePointedUp] (Symbols: geometric: red triangle pointed up).
*/
public val Emoji.Companion.TrianglePointedUp: Emoji get() = _RedTrianglePointedUp
