package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HollowRedCircle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⭕",
        description = "hollow red circle",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("hollow-red-circle", "large-circle"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: other-symbol: hollow red circle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HollowRedCircle: Emoji get() = _HollowRedCircle

/**
 * Alias to emoji [HollowRedCircle] (Symbols: other-symbol: hollow red circle).
*/
public val Emoji.Companion.LargeCircle: Emoji get() = _HollowRedCircle
