package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PartyPopper: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎉",
        description = "party popper",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("party-popper", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Activities: event: party popper.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PartyPopper: Emoji get() = _PartyPopper
