package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MagicWand: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪄",
        description = "magic wand",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("magic-wand", "wand"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: game: magic wand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MagicWand: Emoji get() = _MagicWand

/**
 * Alias to emoji [MagicWand] (Activities: game: magic wand).
*/
public val Emoji.Companion.Wand: Emoji get() = _MagicWand
