package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllGame() {
    add(intArrayOf(0x1f3af), _Bullseye)
    add(intArrayOf(0x1fa80), _YoYo)
    add(intArrayOf(0x1fa81), _Kite)
    add(intArrayOf(0x1f52b), _WaterPistol)
    add(intArrayOf(0x1f3b1), _Pool8Ball)
    add(intArrayOf(0x1f52e), _CrystalBall)
    add(intArrayOf(0x1fa84), _MagicWand)
    add(intArrayOf(0x1f3ae), _VideoGame)
    add(intArrayOf(0x1f579, 0xfe0f), _Joystick)
    add(intArrayOf(0x1f579), _Joystick)
    add(intArrayOf(0x1f3b0), _SlotMachine)
    add(intArrayOf(0x1f3b2), _GameDie)
    add(intArrayOf(0x1f9e9), _PuzzlePiece)
    add(intArrayOf(0x1f9f8), _TeddyBear)
    add(intArrayOf(0x1fa85), _Pinata)
    add(intArrayOf(0x1faa9), _MirrorBall)
    add(intArrayOf(0x1fa86), _NestingDolls)
    add(intArrayOf(0x2660, 0xfe0f), _SpadeSuit)
    add(intArrayOf(0x2660), _SpadeSuit)
    add(intArrayOf(0x2665, 0xfe0f), _HeartSuit)
    add(intArrayOf(0x2665), _HeartSuit)
    add(intArrayOf(0x2666, 0xfe0f), _DiamondSuit)
    add(intArrayOf(0x2666), _DiamondSuit)
    add(intArrayOf(0x2663, 0xfe0f), _ClubSuit)
    add(intArrayOf(0x2663), _ClubSuit)
    add(intArrayOf(0x265f, 0xfe0f), _ChessPawn)
    add(intArrayOf(0x265f), _ChessPawn)
    add(intArrayOf(0x1f0cf), _Joker)
    add(intArrayOf(0x1f004), _MahjongRedDragon)
    add(intArrayOf(0x1f3b4), _FlowerPlayingCards)
}

internal suspend fun SequenceScope<Emoji>.yieldAllGame() {
    yield(_Bullseye)
    yield(_YoYo)
    yield(_Kite)
    yield(_WaterPistol)
    yield(_Pool8Ball)
    yield(_CrystalBall)
    yield(_MagicWand)
    yield(_VideoGame)
    yield(_Joystick)
    yield(_SlotMachine)
    yield(_GameDie)
    yield(_PuzzlePiece)
    yield(_TeddyBear)
    yield(_Pinata)
    yield(_MirrorBall)
    yield(_NestingDolls)
    yield(_SpadeSuit)
    yield(_HeartSuit)
    yield(_DiamondSuit)
    yield(_ClubSuit)
    yield(_ChessPawn)
    yield(_Joker)
    yield(_MahjongRedDragon)
    yield(_FlowerPlayingCards)
}

internal val countGame = 24

/**
 * All Emoji of the Activities: game subgroup.
*/
public fun Emoji.Companion.sequenceGame(): Sequence<Emoji> =
    sequence { yieldAllGame() }

/**
 * All Emoji of the Activities: game subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listGame(): List<Emoji> =
    ArrayList<Emoji>(countGame).also { list -> sequenceGame().forEach { list.add(it) } }

@Deprecated("Renamed listGame.", replaceWith = ReplaceWith("listGame()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allGame(): List<Emoji> =
    listGame()
