package org.kodein.emoji.animals_nature.animal_bug

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Honeybee: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐝",
        description = "honeybee",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("honeybee", "bee"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-bug: honeybee.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Honeybee: Emoji get() = _Honeybee

/**
 * Alias to emoji [Honeybee] (Animals & Nature: animal-bug: honeybee).
*/
public val Emoji.Companion.Bee: Emoji get() = _Honeybee
