package org.kodein.emoji.animals_nature.animal_marine

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SpiralShell: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐚",
        description = "spiral shell",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("spiral-shell", "shell"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-marine: spiral shell.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SpiralShell: Emoji get() = _SpiralShell

/**
 * Alias to emoji [SpiralShell] (Animals & Nature: animal-marine: spiral shell).
*/
public val Emoji.Companion.Shell: Emoji get() = _SpiralShell
