package org.kodein.emoji.animals_nature.animal_marine

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TropicalFish: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐠",
        description = "tropical fish",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("tropical-fish", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: animal-marine: tropical fish.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TropicalFish: Emoji get() = _TropicalFish
