package org.kodein.emoji.animals_nature.plant_flower

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Bouquet: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💐",
        description = "bouquet",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("bouquet", "flowers"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Animals & Nature: plant-flower: bouquet.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Bouquet: Emoji get() = _Bouquet

/**
 * Alias to emoji [Bouquet] (Animals & Nature: plant-flower: bouquet).
*/
public val Emoji.Companion.Flowers: Emoji get() = _Bouquet
