package org.kodein.emoji.animals_nature.plant_flower

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlantFlower() {
    add(intArrayOf(0x1f490), _Bouquet)
    add(intArrayOf(0x1f338), _CherryBlossom)
    add(intArrayOf(0x1f4ae), _WhiteFlower)
    add(intArrayOf(0x1fab7), _Lotus)
    add(intArrayOf(0x1f3f5, 0xfe0f), _Rosette)
    add(intArrayOf(0x1f3f5), _Rosette)
    add(intArrayOf(0x1f339), _Rose)
    add(intArrayOf(0x1f940), _WiltedFlower)
    add(intArrayOf(0x1f33a), _Hibiscus)
    add(intArrayOf(0x1f33b), _Sunflower)
    add(intArrayOf(0x1f33c), _Blossom)
    add(intArrayOf(0x1f337), _Tulip)
    add(intArrayOf(0x1fabb), _Hyacinth)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPlantFlower() {
    yield(_Bouquet)
    yield(_CherryBlossom)
    yield(_WhiteFlower)
    yield(_Lotus)
    yield(_Rosette)
    yield(_Rose)
    yield(_WiltedFlower)
    yield(_Hibiscus)
    yield(_Sunflower)
    yield(_Blossom)
    yield(_Tulip)
    yield(_Hyacinth)
}

internal val countPlantFlower = 12

/**
 * All Emoji of the Animals & Nature: plant-flower subgroup.
*/
public fun Emoji.Companion.sequencePlantFlower(): Sequence<Emoji> =
    sequence { yieldAllPlantFlower() }

/**
 * All Emoji of the Animals & Nature: plant-flower subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPlantFlower(): List<Emoji> =
    ArrayList<Emoji>(countPlantFlower).also { list -> sequencePlantFlower().forEach { list.add(it) } }

@Deprecated("Renamed listPlantFlower.", replaceWith = ReplaceWith("listPlantFlower()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPlantFlower(): List<Emoji> =
    listPlantFlower()
