package org.kodein.emoji.flags

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.flags.flag.*
import org.kodein.emoji.flags.country_flag.*
import org.kodein.emoji.flags.subdivision_flag.*


internal fun EmojiFinder.addAllFlags() {
    addAllFlag()
    addAllCountryFlag()
    addAllSubdivisionFlag()
}

internal suspend fun SequenceScope<Emoji>.yieldAllFlags() {
    yieldAllFlag()
    yieldAllCountryFlag()
    yieldAllSubdivisionFlag()
}

internal val countFlags = 269

/**
 * All Emoji of the Flags group.
*/
public fun Emoji.Companion.sequenceFlags(): Sequence<Emoji> =
    sequence { yieldAllFlags() }

/**
 * All Emoji of the Flags group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFlags(): List<Emoji> =
    ArrayList<Emoji>(countFlags).also { list -> sequenceFlags().forEach { list.add(it) } }

internal fun allFlagsSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "flag" to { Emoji.listFlag() },
        "country_flag" to { Emoji.listCountryFlag() },
        "subdivision_flag" to { Emoji.listSubdivisionFlag() },
    )
