package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAruba: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇼",
        description = "flag: Aruba",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-aruba", "aruba-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Aruba.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAruba: Emoji get() = _FlagAruba

/**
 * Alias to emoji [FlagAruba] (Flags: country-flag: flag: Aruba).
*/
public val Emoji.Companion.ArubaFlag: Emoji get() = _FlagAruba
