package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCanaryIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇨",
        description = "flag: Canary Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-canary-islands", "canary-islands-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Canary Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCanaryIslands: Emoji get() = _FlagCanaryIslands

/**
 * Alias to emoji [FlagCanaryIslands] (Flags: country-flag: flag: Canary Islands).
*/
public val Emoji.Companion.CanaryIslandsFlag: Emoji get() = _FlagCanaryIslands
