package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCongoKinshasa: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇩",
        description = "flag: Congo - Kinshasa",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-congo-kinshasa", "congo-kinshasa-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.3333334f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Congo - Kinshasa.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCongoKinshasa: Emoji get() = _FlagCongoKinshasa

/**
 * Alias to emoji [FlagCongoKinshasa] (Flags: country-flag: flag: Congo - Kinshasa).
*/
public val Emoji.Companion.CongoKinshasaFlag: Emoji get() = _FlagCongoKinshasa
