package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCyprus: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇾",
        description = "flag: Cyprus",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-cyprus", "cyprus-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Cyprus.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCyprus: Emoji get() = _FlagCyprus

/**
 * Alias to emoji [FlagCyprus] (Flags: country-flag: flag: Cyprus).
*/
public val Emoji.Companion.CyprusFlag: Emoji get() = _FlagCyprus
