package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagHungary: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇭🇺",
        description = "flag: Hungary",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-hungary", "hungary-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Hungary.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagHungary: Emoji get() = _FlagHungary

/**
 * Alias to emoji [FlagHungary] (Flags: country-flag: flag: Hungary).
*/
public val Emoji.Companion.HungaryFlag: Emoji get() = _FlagHungary
