package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagIreland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇪",
        description = "flag: Ireland",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-ireland", "ireland-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Ireland.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagIreland: Emoji get() = _FlagIreland

/**
 * Alias to emoji [FlagIreland] (Flags: country-flag: flag: Ireland).
*/
public val Emoji.Companion.IrelandFlag: Emoji get() = _FlagIreland
