package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLiechtenstein: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇮",
        description = "flag: Liechtenstein",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-liechtenstein", "liechtenstein-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6666666f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Liechtenstein.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLiechtenstein: Emoji get() = _FlagLiechtenstein

/**
 * Alias to emoji [FlagLiechtenstein] (Flags: country-flag: flag: Liechtenstein).
*/
public val Emoji.Companion.LiechtensteinFlag: Emoji get() = _FlagLiechtenstein
