package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLuxembourg: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇺",
        description = "flag: Luxembourg",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-luxembourg", "luxembourg-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6666666f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Luxembourg.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLuxembourg: Emoji get() = _FlagLuxembourg

/**
 * Alias to emoji [FlagLuxembourg] (Flags: country-flag: flag: Luxembourg).
*/
public val Emoji.Companion.LuxembourgFlag: Emoji get() = _FlagLuxembourg
