package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNamibia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇦",
        description = "flag: Namibia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-namibia", "namibia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Namibia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNamibia: Emoji get() = _FlagNamibia

/**
 * Alias to emoji [FlagNamibia] (Flags: country-flag: flag: Namibia).
*/
public val Emoji.Companion.NamibiaFlag: Emoji get() = _FlagNamibia
