package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNetherlands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇱",
        description = "flag: Netherlands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-netherlands", "netherlands-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Netherlands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNetherlands: Emoji get() = _FlagNetherlands

/**
 * Alias to emoji [FlagNetherlands] (Flags: country-flag: flag: Netherlands).
*/
public val Emoji.Companion.NetherlandsFlag: Emoji get() = _FlagNetherlands
