package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNewCaledonia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇨",
        description = "flag: New Caledonia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-new-caledonia", "new-caledonia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: New Caledonia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNewCaledonia: Emoji get() = _FlagNewCaledonia

/**
 * Alias to emoji [FlagNewCaledonia] (Flags: country-flag: flag: New Caledonia).
*/
public val Emoji.Companion.NewCaledoniaFlag: Emoji get() = _FlagNewCaledonia
