package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNorthKorea: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇰🇵",
        description = "flag: North Korea",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-north-korea", "north-korea-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: North Korea.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNorthKorea: Emoji get() = _FlagNorthKorea

/**
 * Alias to emoji [FlagNorthKorea] (Flags: country-flag: flag: North Korea).
*/
public val Emoji.Companion.NorthKoreaFlag: Emoji get() = _FlagNorthKorea
