package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNorthMacedonia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇰",
        description = "flag: North Macedonia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-north-macedonia", "macedonia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: North Macedonia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNorthMacedonia: Emoji get() = _FlagNorthMacedonia

/**
 * Alias to emoji [FlagNorthMacedonia] (Flags: country-flag: flag: North Macedonia).
*/
public val Emoji.Companion.MacedoniaFlag: Emoji get() = _FlagNorthMacedonia
