package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNorthernMarianaIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇵",
        description = "flag: Northern Mariana Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-northern-mariana-islands", "northern-mariana-islands-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Northern Mariana Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNorthernMarianaIslands: Emoji get() = _FlagNorthernMarianaIslands

/**
 * Alias to emoji [FlagNorthernMarianaIslands] (Flags: country-flag: flag: Northern Mariana Islands).
*/
public val Emoji.Companion.NorthernMarianaIslandsFlag: Emoji get() = _FlagNorthernMarianaIslands
