package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPakistan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇰",
        description = "flag: Pakistan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-pakistan", "pakistan-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Pakistan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPakistan: Emoji get() = _FlagPakistan

/**
 * Alias to emoji [FlagPakistan] (Flags: country-flag: flag: Pakistan).
*/
public val Emoji.Companion.PakistanFlag: Emoji get() = _FlagPakistan
