package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPalestinianTerritories: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇸",
        description = "flag: Palestinian Territories",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-palestinian-territories", "palestinian-territories-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Palestinian Territories.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPalestinianTerritories: Emoji get() = _FlagPalestinianTerritories

/**
 * Alias to emoji [FlagPalestinianTerritories] (Flags: country-flag: flag: Palestinian Territories).
*/
public val Emoji.Companion.PalestinianTerritoriesFlag: Emoji get() = _FlagPalestinianTerritories
