package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSamoa: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇼🇸",
        description = "flag: Samoa",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-samoa", "samoa-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Samoa.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSamoa: Emoji get() = _FlagSamoa

/**
 * Alias to emoji [FlagSamoa] (Flags: country-flag: flag: Samoa).
*/
public val Emoji.Companion.SamoaFlag: Emoji get() = _FlagSamoa
