package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSaudiArabia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇦",
        description = "flag: Saudi Arabia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-saudi-arabia", "saudi-arabia-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Saudi Arabia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSaudiArabia: Emoji get() = _FlagSaudiArabia

/**
 * Alias to emoji [FlagSaudiArabia] (Flags: country-flag: flag: Saudi Arabia).
*/
public val Emoji.Companion.SaudiArabiaFlag: Emoji get() = _FlagSaudiArabia
