package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagStVincentGrenadines: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇻🇨",
        description = "flag: St. Vincent & Grenadines",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-st-vincent-grenadines", "st-vincent-grenadines-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: St. Vincent & Grenadines.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagStVincentGrenadines: Emoji get() = _FlagStVincentGrenadines

/**
 * Alias to emoji [FlagStVincentGrenadines] (Flags: country-flag: flag: St. Vincent & Grenadines).
*/
public val Emoji.Companion.StVincentGrenadinesFlag: Emoji get() = _FlagStVincentGrenadines
