package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUnitedNations: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇺🇳",
        description = "flag: United Nations",
        unicodeVersion = UnicodeVersion(4, 0),
        aliases = listOf("flag-united-nations", "united-nations-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: United Nations.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUnitedNations: Emoji get() = _FlagUnitedNations

/**
 * Alias to emoji [FlagUnitedNations] (Flags: country-flag: flag: United Nations).
*/
public val Emoji.Companion.UnitedNationsFlag: Emoji get() = _FlagUnitedNations
