package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagVaticanCity: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇻🇦",
        description = "flag: Vatican City",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-vatican-city", "vatican-city-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Vatican City.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagVaticanCity: Emoji get() = _FlagVaticanCity

/**
 * Alias to emoji [FlagVaticanCity] (Flags: country-flag: flag: Vatican City).
*/
public val Emoji.Companion.VaticanCityFlag: Emoji get() = _FlagVaticanCity
