package org.kodein.emoji.flags.subdivision_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagEngland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏴󠁧󠁢󠁥󠁮󠁧󠁿",
        description = "flag: England",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("flag-england", "england-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6666666f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: subdivision-flag: flag: England.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagEngland: Emoji get() = _FlagEngland

/**
 * Alias to emoji [FlagEngland] (Flags: subdivision-flag: flag: England).
*/
public val Emoji.Companion.EnglandFlag: Emoji get() = _FlagEngland
