package org.kodein.emoji.flags.subdivision_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagScotland: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏴󠁧󠁢󠁳󠁣󠁴󠁿",
        description = "flag: Scotland",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("flag-scotland", "scotland-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6666666f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: subdivision-flag: flag: Scotland.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagScotland: Emoji get() = _FlagScotland

/**
 * Alias to emoji [FlagScotland] (Flags: subdivision-flag: flag: Scotland).
*/
public val Emoji.Companion.ScotlandFlag: Emoji get() = _FlagScotland
