package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClinkingBeerMugs: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍻",
        description = "clinking beer mugs",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("clinking-beer-mugs", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: clinking beer mugs.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClinkingBeerMugs: Emoji get() = _ClinkingBeerMugs
