package org.kodein.emoji.food_drink.food_sweet

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SoftIceCream: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍦",
        description = "soft ice cream",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("soft-ice-cream", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: food-sweet: soft ice cream.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SoftIceCream: Emoji get() = _SoftIceCream
