package org.kodein.emoji.food_drink.food_vegetable

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GingerRoot: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫚",
        description = "ginger root",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("ginger-root", "ginger"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: food-vegetable: ginger root.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GingerRoot: Emoji get() = _GingerRoot

/**
 * Alias to emoji [GingerRoot] (Food & Drink: food-vegetable: ginger root).
*/
public val Emoji.Companion.Ginger: Emoji get() = _GingerRoot
