package org.kodein.emoji.objects.book_paper

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GreenBook: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📗",
        description = "green book",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("green-book", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: book-paper: green book.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GreenBook: Emoji get() = _GreenBook
