package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MilitaryHelmet: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪖",
        description = "military helmet",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("military-helmet", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: military helmet.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MilitaryHelmet: Emoji get() = _MilitaryHelmet
