package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ThongSandal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩴",
        description = "thong sandal",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("thong-sandal", "flip-flop"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: clothing: thong sandal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ThongSandal: Emoji get() = _ThongSandal

/**
 * Alias to emoji [ThongSandal] (Objects: clothing: thong sandal).
*/
public val Emoji.Companion.FlipFlop: Emoji get() = _ThongSandal
