package org.kodein.emoji.objects.mail

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BallotBoxWithBallot: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗳️",
        description = "ballot box with ballot",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("ballot-box-with-ballot", "ballot-box"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: mail: ballot box with ballot.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BallotBoxWithBallot: Emoji get() = _BallotBoxWithBallot

/**
 * Alias to emoji [BallotBoxWithBallot] (Objects: mail: ballot box with ballot).
*/
public val Emoji.Companion.BallotBox: Emoji get() = _BallotBoxWithBallot
