package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Coin: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪙",
        description = "coin",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("coin", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: money: coin.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Coin: Emoji get() = _Coin
