package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _StudioMicrophone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎙️",
        description = "studio microphone",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("studio-microphone", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: music: studio microphone.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.StudioMicrophone: Emoji get() = _StudioMicrophone
